package com.ejie.ab04b.dao;

import com.ejie.x38.dao.RowNumResultSetExtractor;
import com.ejie.x38.dto.JQGridManager;
import com.ejie.x38.dto.JQGridManagerJerarquia;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableRowDto;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab04b.constantes.Secuencias;
import com.ejie.ab04b.model.TipoApertura;

/**
 * tipoAperturaDaoImpl generated by UDA, 27-dic-2016 9:57:25.
 * 
 * @author UDA
 */

@Repository()
@Transactional()
public class TipoAperturaDaoImpl implements TipoAperturaDao {
	private JdbcTemplate jdbcTemplate;

	private static final String QUERY_SELECT = "SELECT t1.TIPAPE_071 TIPAPE071, t1.DESAPE_EU_071 DESAPEEU071, t1.DESAPE_ES_071 DESAPEES071, t1.FECBAJ_071 FECBAJ071 ";

	/*
	 * ROW_MAPPERS
	 */
	private RowMapper<TipoApertura> rwMap = new RowMapper<TipoApertura>() {
		public TipoApertura mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new TipoApertura(resultSet.getString("TIPAPE071"),
					resultSet.getString("DESAPEEU071"),
					resultSet.getString("DESAPEES071"),
					resultSet.getDate("FECBAJ071"));
		}
	};

	private RowMapper<TipoApertura> rwMapPK = new RowMapper<TipoApertura>() {
		public TipoApertura mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new TipoApertura(resultSet.getString("TIPAPE071"),
					resultSet.getString("DESAPEEU071"),
					resultSet.getString("DESAPEES071"),
					resultSet.getDate("FECBAJ071"));
		}
	};

	/**
	 * Rowmapper para Jerarquía
	 * 
	 * dataSource DataSource
	 * 
	 */
	private RowMapper<JerarquiaDto<TipoApertura>> rwMapJerarquia = new RowMapper<JerarquiaDto<TipoApertura>>() {
		public JerarquiaDto<TipoApertura> mapRow(ResultSet resultSet,
				int rowNum) throws SQLException {

			TipoApertura tipoApertura = new TipoApertura(
					resultSet.getString("TIPAPE071"),
					resultSet.getString("DESAPEEU071"),
					resultSet.getString("DESAPEES071"),
					resultSet.getDate("FECBAJ071"));

			JerarquiaDto<TipoApertura> jerarquia = new JerarquiaDto<TipoApertura>();
			jerarquia.setModel(tipoApertura);
			jerarquia.setLevel(resultSet.getBigDecimal("LEVEL").intValue());
			jerarquia.setParentNodes(resultSet.getString("PARENTNODES"));
			jerarquia.setIsLeaf(
					Boolean.parseBoolean(resultSet.getString("ISLEAF")));
			jerarquia.setFilter(
					Boolean.parseBoolean(resultSet.getString("FILTER")));
			return jerarquia;
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * dataSource DataSource
	 *
	 * @param dataSource
	 *            the new data source
	 */
	@Resource()
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/*
	 * OPERACIONES CRUD
	 */

	/**
	 * Inserts a single row in the Ab04b71s00 table.
	 * 
	 * tipoApertura TipoApertura tipoApertura
	 *
	 * @param tipoApertura
	 *            the tipo apertura
	 * @return the tipo apertura
	 */
	public TipoApertura add(TipoApertura tipoApertura) {

		Long tipoAperturaPK = Secuencias.TIPOS_APERTURAS
				.getNextLong(this.jdbcTemplate);
		if (tipoAperturaPK != null) {
			tipoApertura.setTipape071(tipoAperturaPK.toString());
		}

		String query = "INSERT INTO AB0471S00 (TIPAPE_071, DESAPE_EU_071, DESAPE_ES_071, FECBAJ_071) VALUES (?,?,?,?)";
		this.jdbcTemplate.update(query, tipoApertura.getTipape071(),
				tipoApertura.getDesapeEu071(), tipoApertura.getDesapeEs071(),
				tipoApertura.getFecbaj071());
		return tipoApertura;
	}

	/**
	 * Updates a single row in the Ab04b71s00 table.
	 * 
	 * tipoApertura TipoApertura tipoApertura
	 *
	 * @param tipoApertura
	 *            the tipo apertura
	 * @return the tipo apertura
	 */
	public TipoApertura update(TipoApertura tipoApertura) {
		String query = "UPDATE AB0471S00 SET DESAPE_EU_071=?, DESAPE_ES_071=?, FECBAJ_071=? WHERE TIPAPE_071=? ";
		this.jdbcTemplate.update(query, tipoApertura.getDesapeEu071(),
				tipoApertura.getDesapeEs071(), tipoApertura.getFecbaj071(),
				tipoApertura.getTipape071());
		return tipoApertura;
	}

	/**
	 * Finds a single row in the Ab04b71s00 table.
	 * 
	 * tipoApertura TipoApertura tipoApertura
	 *
	 * @param tipoApertura
	 *            the tipo apertura
	 * @return the tipo apertura
	 */
	@Transactional(readOnly = true)
	public TipoApertura find(TipoApertura tipoApertura) {
		StringBuilder query = new StringBuilder(
				TipoAperturaDaoImpl.QUERY_SELECT);
		query.append(" FROM AB0471S00 t1  WHERE t1.TIPAPE_071 = ? ");

		List<TipoApertura> tipoAperturaList = this.jdbcTemplate.query(
				query.toString(), this.rwMap, tipoApertura.getTipape071());
		return (TipoApertura) DataAccessUtils.uniqueResult(tipoAperturaList);
	}

	/**
	 * Removes a single row in the Ab04b71s00 table.
	 * 
	 * tipoApertura TipoApertura
	 *
	 * @param tipoApertura
	 *            the tipo apertura
	 */
	public void remove(TipoApertura tipoApertura) {
		String query = "DELETE FROM AB0471S00 WHERE TIPAPE_071=? ";
		this.jdbcTemplate.update(query, tipoApertura.getTipape071());
	}

	/**
	 * Finds a list of rows in the Ab04b71s00 table.
	 * 
	 * tipoApertura TipoApertura jqGridRequestDto JQGridRequestDto List
	 * <TipoApertura>
	 *
	 * @param tipoApertura
	 *            the tipo apertura
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @return the list
	 */
	@Transactional(readOnly = true)
	public List<TipoApertura> findAll(TipoApertura tipoApertura,
			JQGridRequestDto jqGridRequestDto) {
		StringBuilder query = new StringBuilder(
				TipoAperturaDaoImpl.QUERY_SELECT);
		query.append(" FROM AB0471S00 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(tipoApertura);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		return (List<TipoApertura>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Finds rows in the Ab04b71s00 table using like.
	 * 
	 * tipoApertura TipoApertura jqGridRequestDto JQGridRequestDto startsWith
	 * Boolean List<Ab04b71s00>
	 *
	 * @param tipoApertura
	 *            the tipo apertura
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @param startsWith
	 *            the starts with
	 * @return the list
	 */
	@Transactional(readOnly = true)
	public List<TipoApertura> findAllLike(TipoApertura tipoApertura,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				TipoAperturaDaoImpl.QUERY_SELECT);
		query.append("FROM AB0471S00 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(tipoApertura,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		return (List<TipoApertura>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Counts rows in the Ab04b71s00 table.
	 * 
	 * tipoApertura TipoApertura Long
	 *
	 * @param tipoApertura
	 *            the tipo apertura
	 * @return the long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(TipoApertura tipoApertura) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM AB0471S00 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(tipoApertura);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Counts rows in the Ab04b71s00 table using like.
	 * 
	 * tipoApertura TipoApertura startsWith Boolean Long
	 *
	 * @param tipoApertura
	 *            the tipo apertura
	 * @param startsWith
	 *            the starts with
	 * @return the long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(TipoApertura tipoApertura,
			Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM AB0471S00 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(tipoApertura,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Reorder the data list of Ab04b71s00 selected for rup_table.
	 * 
	 * tipoApertura TipoApertura jqGridRequestDto JQGridRequestDto startsWith
	 * Boolean List<TableRowDto<TipoApertura>>
	 *
	 * @param tipoApertura
	 *            the tipo apertura
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @param startsWith
	 *            the starts with
	 * @return the list
	 */
	@Override
	public List<TableRowDto<TipoApertura>> reorderSelection(
			TipoApertura tipoApertura, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		// SELECT
		StringBuilder query = new StringBuilder(
				TipoAperturaDaoImpl.QUERY_SELECT);
		// FROM
		query.append(" FROM AB0471S00 t1 ");
		// FILTRADO
		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(tipoApertura,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		// Parámetros de filtrado
		@SuppressWarnings("unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhere.get("params");

		// SQL para la reordenación
		StringBuilder sbReorderSelectionSQL = JQGridManager.getReorderQuery(
				query, jqGridRequestDto, TipoApertura.class, filterParamList,
				"TIPAPE071");

		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(),
				new RowNumResultSetExtractor<TipoApertura>(this.rwMapPK,
						jqGridRequestDto),
				filterParamList.toArray());
	}

	/**
	 * Search method for rup_table.
	 * 
	 * filterParams TipoApertura searchParams TipoApertura jqGridRequestDto
	 * JQGridRequestDto startsWith Boolean List<TableRowDto<TipoApertura>>
	 *
	 * @param filterParams
	 *            the filter params
	 * @param searchParams
	 *            the search params
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @param startsWith
	 *            the starts with
	 * @return the list
	 */
	@Override
	public List<TableRowDto<TipoApertura>> search(TipoApertura filterParams,
			TipoApertura searchParams, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		// SELECT
		StringBuilder query = new StringBuilder(
				TipoAperturaDaoImpl.QUERY_SELECT);
		// FROM
		query.append(" FROM AB0471S00 t1 ");
		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// FILTRADO
		Map<String, ?> mapaWhereFilter = this.getWhereLikeMap(filterParams,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhereFilter.get("query"));
		query.append(where);
		// Filter params
		@SuppressWarnings("unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhereFilter
				.get("params");

		// BUSQUEDA
		Map<String, Object> mapaWhereSearch = this.getWhereLikeMap(searchParams,
				startsWith);
		String searchSQL = ((StringBuilder) mapaWhereSearch.get("query"))
				.toString();
		// Search params
		@SuppressWarnings("unchecked")
		List<Object> searchParamList = (List<Object>) mapaWhereSearch
				.get("params");

		// SQL
		StringBuilder sbReorderSelectionSQL = JQGridManager.getSearchQuery(
				query, jqGridRequestDto, TipoApertura.class, filterParamList,
				searchSQL, searchParamList, from_alias, "TIPAPE071");

		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(),
				new RowNumResultSetExtractor<TipoApertura>(this.rwMapPK,
						jqGridRequestDto),
				filterParamList.toArray());
	}

	/**
	 * Remove multiple method for rup_table.
	 * 
	 * filtertipoApertura TipoApertura jqGridRequestDto JQGridRequestDto
	 * startsWith Boolean
	 *
	 * @param filtertipoApertura
	 *            the filtertipo apertura
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @param startsWith
	 *            the starts with
	 */
	@Override
	public void removeMultiple(TipoApertura filtertipoApertura,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		// SELECT
		/** TODO: select por clave */
		StringBuilder query = new StringBuilder(
				TipoAperturaDaoImpl.QUERY_SELECT);
		// FROM
		query.append(" FROM AB0471S00 t1 ");

		// WHERE
		Map<String, Object> mapaWhere = this.getWhereLikeMap(filtertipoApertura,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		@SuppressWarnings("unchecked")
		List<Object> params = (List<Object>) mapaWhere.get("params");

		StringBuilder sbRemoveMultipleSQL = JQGridManager
				.getRemoveMultipleQuery(jqGridRequestDto, TipoApertura.class,
						query, params, "TIPAPE071");
		this.jdbcTemplate.update(sbRemoveMultipleSQL.toString(),
				params.toArray());
	}

	/**
	 * Filter in the hierarchical Ab04b71s00 table.
	 * 
	 * filtertipoApertura TipoApertura jqGridRequestDto JQGridRequestDto
	 * List<JerarquiaDto<Ab04b71s00>>
	 *
	 * @param filtertipoApertura
	 *            the filtertipo apertura
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @return the list
	 */
	@Override
	public List<JerarquiaDto<TipoApertura>> findAllLikeJerarquia(
			TipoApertura filtertipoApertura,
			JQGridRequestDto jqGridRequestDto) {
		// SELECT
		StringBuilder query = new StringBuilder(
				TipoAperturaDaoImpl.QUERY_SELECT);
		// FROM
		// StringBuilder from = new StringBuilder("FROM AB04B71S00 t1 ");
		List<String> from = new ArrayList<String>();
		from.add("AB0471S00");
		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder(""); joins.append(
		 * "AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>(); businessFilters.append(
		 * "   AND t1.EJIE = ?  "); businessParams.add("1");
		 */

		// FILTRO
		Map<String, ?> mapaWhere = this.getWhereLikeMap(filtertipoApertura,
				false);

		// JERARQUIA
		// Especificar la columna padre correspondiente en lugar de la generada
		// por defecto (ID_PADRE)
		query = JQGridManagerJerarquia.getQuery(jqGridRequestDto, query,
				mapaWhere, "TIPAPE071", "ID_PADRE", "NOMBRE", from, from_alias);

		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y
		 * condiciones de negocio
		 */
		// query = JQGridManagerJerarquia.getQuery(jqGridRequestDto, query,
		// mapaWhere, "ID", "ID_PADRE", "NOMBRE", from, from_alias, joins,
		// businessFilters, businessParams);

		// PAGINACION
		if (jqGridRequestDto != null) {
			query = JQGridManagerJerarquia.getPaginationQuery(jqGridRequestDto,
					query);
		}

		List<?> params = (List<?>) mapaWhere.get("params");
		return this.jdbcTemplate.query(query.toString(), this.rwMapJerarquia,
				params.toArray());
	}

	/**
	 * Count rows in hierarchy.
	 * 
	 * filtertipoApertura TipoApertura jqGridRequestDto JQGridRequestDto Long
	 *
	 * @param filtertipoApertura
	 *            the filtertipo apertura
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @return the long
	 */
	@Override
	public Long findAllLikeCountJerarquia(TipoApertura filtertipoApertura,
			JQGridRequestDto jqGridRequestDto) {
		// FROM
		// StringBuilder from = new StringBuilder("FROM AB04B71S00 t1 ");
		List<String> from = new ArrayList<String>();
		from.add("AB0471S00");

		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder(""); joins.append(
		 * "AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>(); businessFilters.append(
		 * "   AND t1.EJIE = ?  "); businessParams.add("1");
		 */

		// FILTRO
		Map<String, ?> mapaWhere = this.getWhereLikeMap(filtertipoApertura,
				false);

		// JERARQUIA
		// Especificar la columna padre correspondiente en lugar de la generada
		// por defecto (ID_PADRE)
		StringBuilder query = JQGridManagerJerarquia.getQueryCount(
				jqGridRequestDto, mapaWhere, "TIPAPE071", "ID_PADRE", from,
				from_alias);

		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y
		 * condiciones de negocio
		 */
		// StringBuilder query =
		// JQGridManagerJerarquia.getQueryCount(jqGridRequestDto, mapaWhere,
		// "ID", "ID_PADRE", from, from_alias, joins, businessFilters,
		// businessParams);

		List<?> params = (List<?>) mapaWhere.get("params");
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Find dependent hierarchical rows.
	 * 
	 * filtertipoApertura TipoApertura jqGridRequestDto JQGridRequestDto
	 * List<TableRowDto<TipoApertura>>
	 *
	 * @param filtertipoApertura
	 *            the filtertipo apertura
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @return the list
	 */
	@Override
	public List<TableRowDto<TipoApertura>> findAllChild(
			TipoApertura filtertipoApertura,
			JQGridRequestDto jqGridRequestDto) {

		// FROM
		// StringBuilder from = new StringBuilder("FROM AB04B71S00 t1 ");
		List<String> from = new ArrayList<String>();
		from.add("AB0471S00");

		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder(""); joins.append(
		 * "AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>(); businessFilters.append(
		 * "   AND t1.EJIE = ?  "); businessParams.add("1");
		 */

		// FILTRO
		Map<String, ?> mapaWhere = this.getWhereLikeMap(filtertipoApertura,
				false);

		// MULTISELECCION
		// Especificar la columna padre correspondiente en lugar de la generada
		// por defecto (ID_PADRE)
		StringBuilder query = JQGridManagerJerarquia.getQueryChildren(
				jqGridRequestDto, mapaWhere, "TIPAPE071", "ID_PADRE", from,
				from_alias);

		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y
		 * condiciones de negocio
		 */
		// StringBuilder query =
		// JQGridManagerJerarquia.getQueryChildren(jqGridRequestDto, mapaWhere,
		// "ID", "ID_PADRE", from, from_alias, joins, businessFilters,
		// businessParams);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.query(query.toString(),
				new RowNumResultSetExtractor<TipoApertura>(this.rwMapPK,
						"TIPAPE071"),
				params.toArray());
	}

	/*
	 * MÉTODOS PRIVADOS
	 */

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Ab04b71s00 entity.
	 * 
	 * tipoApertura Ab04b71s00 Bean with the criteria values to filter by. Map
	 * created with two keys key query stores the sql query syntax key params
	 * stores the parameter values to be used in the condition sentence.
	 *
	 * @param tipoApertura
	 *            the tipo apertura
	 * @return the where map
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(TipoApertura tipoApertura) {

		StringBuilder where = new StringBuilder(
				TipoAperturaDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (tipoApertura != null && tipoApertura.getTipape071() != null) {
			where.append(" AND t1.TIPAPE_071 = ?");
			params.add(tipoApertura.getTipape071());
		}
		if (tipoApertura != null && tipoApertura.getDesapeEu071() != null) {
			where.append(" AND t1.DESAPE_EU_071 = ?");
			params.add(tipoApertura.getDesapeEu071());
		}
		if (tipoApertura != null && tipoApertura.getDesapeEs071() != null) {
			where.append(" AND t1.DESAPE_ES_071 = ?");
			params.add(tipoApertura.getDesapeEs071());
		}

		where.append(
				" AND (t1.FECBAJ_071 < SYSDATE OR t1.FECBAJ_071 IS NULL) ");

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Ab04b71s00 entity.
	 * 
	 * tipoApertura Ab04b71s00 Bean with the criteria values to filter by.
	 * startsWith Boolean Map created with two keys key query stores the sql
	 * query syntax key params stores the parameter values to be used in the
	 * condition sentence.
	 *
	 * @param tipoApertura
	 *            the tipo apertura
	 * @param startsWith
	 *            the starts with
	 * @return the where like map
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, Object> getWhereLikeMap(TipoApertura tipoApertura,
			Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				TipoAperturaDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (tipoApertura != null && tipoApertura.getTipape071() != null) {
			where.append(" AND UPPER(t1.TIPAPE_071) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tipoApertura.getTipape071().toUpperCase() + "%");
			} else {
				params.add(
						"%" + tipoApertura.getTipape071().toUpperCase() + "%");
			}
			where.append(" AND t1.TIPAPE_071 IS NOT NULL");
		}
		if (tipoApertura != null && tipoApertura.getDesapeEu071() != null) {
			where.append(" AND UPPER(t1.DESAPE_EU_071) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tipoApertura.getDesapeEu071().toUpperCase() + "%");
			} else {
				params.add("%" + tipoApertura.getDesapeEu071().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.DESAPE_EU_071 IS NOT NULL");
		}
		if (tipoApertura != null && tipoApertura.getDesapeEs071() != null) {
			where.append(" AND UPPER(t1.DESAPE_ES_071) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tipoApertura.getDesapeEs071().toUpperCase() + "%");
			} else {
				params.add("%" + tipoApertura.getDesapeEs071().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.DESAPE_ES_071 IS NOT NULL");
		}

		where.append(
				" AND (t1.FECBAJ_071 < SYSDATE OR t1.FECBAJ_071 IS NULL) ");

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;
}
